/*
 * Decompiled with CFR 0.152.
 */
package com.xiangcao.xiangcaomengjia.network;

import com.xiangcao.xiangcaomengjia.config.PriceVariationData;
import com.xiangcao.xiangcaomengjia.config.XiangcaoTierConfig;
import com.xiangcao.xiangcaomengjia.network.PacketAddTrade;
import com.xiangcao.xiangcaomengjia.network.PacketOpenConfigScreen;
import com.xiangcao.xiangcaomengjia.network.PacketPriceMultiplier;
import com.xiangcao.xiangcaomengjia.network.PacketReloadTrades;
import com.xiangcao.xiangcaomengjia.network.PacketRemoveTrade;
import com.xiangcao.xiangcaomengjia.network.PacketRequestTradeList;
import com.xiangcao.xiangcaomengjia.network.PacketSaveTrades;
import com.xiangcao.xiangcaomengjia.network.PacketTradeList;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public final class XiangcaoNet {
    private static final String PROTOCOL = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"xiangcaomengjia", (String)"main"), () -> "1", "1"::equals, "1"::equals);
    private static int id;

    public static void register() {
        CHANNEL.registerMessage(id++, PacketPriceMultiplier.class, PacketPriceMultiplier::encode, PacketPriceMultiplier::decode, (pkt, sup) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)sup.get();
            ctx.enqueueWork(() -> PacketPriceMultiplier.handle(pkt, ctx));
            ctx.setPacketHandled(true);
        });
        CHANNEL.registerMessage(id++, PacketTradeList.class, PacketTradeList::encode, PacketTradeList::decode, (pkt, sup) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)sup.get();
            ctx.enqueueWork(() -> PacketTradeList.handle(pkt, ctx));
            ctx.setPacketHandled(true);
        });
        CHANNEL.registerMessage(id++, PacketRequestTradeList.class, PacketRequestTradeList::encode, PacketRequestTradeList::decode, (pkt, sup) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)sup.get();
            ctx.enqueueWork(() -> PacketRequestTradeList.handle(pkt, ctx));
            ctx.setPacketHandled(true);
        });
        CHANNEL.registerMessage(id++, PacketAddTrade.class, PacketAddTrade::encode, PacketAddTrade::decode, (pkt, sup) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)sup.get();
            ctx.enqueueWork(() -> PacketAddTrade.handle(pkt, ctx));
            ctx.setPacketHandled(true);
        });
        CHANNEL.registerMessage(id++, PacketRemoveTrade.class, PacketRemoveTrade::encode, PacketRemoveTrade::decode, (pkt, sup) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)sup.get();
            ctx.enqueueWork(() -> PacketRemoveTrade.handle(pkt, ctx));
            ctx.setPacketHandled(true);
        });
        CHANNEL.registerMessage(id++, PacketSaveTrades.class, PacketSaveTrades::encode, PacketSaveTrades::decode, (pkt, sup) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)sup.get();
            ctx.enqueueWork(() -> PacketSaveTrades.handle(pkt, ctx));
            ctx.setPacketHandled(true);
        });
        CHANNEL.registerMessage(id++, PacketReloadTrades.class, PacketReloadTrades::encode, PacketReloadTrades::decode, (pkt, sup) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)sup.get();
            ctx.enqueueWork(() -> PacketReloadTrades.handle(pkt, ctx));
            ctx.setPacketHandled(true);
        });
        CHANNEL.registerMessage(id++, PacketOpenConfigScreen.class, PacketOpenConfigScreen::encode, PacketOpenConfigScreen::decode, (pkt, sup) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)sup.get();
            ctx.enqueueWork(() -> {
                if (ctx.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                    try {
                        Class.forName("com.xiangcao.xiangcaomengjia.client.ClientPackets").getMethod("openConfigScreen", new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Open config screen (client)", e);
                    }
                }
            });
            ctx.setPacketHandled(true);
        });
    }

    public static void syncPriceMultiplierToPlayer(ServerPlayer player) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            PriceVariationData data = PriceVariationData.get(level2);
            Map<String, Double> map = XiangcaoTierConfig.priceVariationEnabled() ? data.getEffectiveMultipliersForDisplay(level2) : data.getItemMultipliers();
            CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketPriceMultiplier(map));
        }
    }

    public static void broadcastPriceMultiplier(ServerLevel level) {
        PriceVariationData data = PriceVariationData.get(level);
        Map<String, Double> map = XiangcaoTierConfig.priceVariationEnabled() ? data.getEffectiveMultipliersForDisplay(level) : data.getItemMultipliers();
        CHANNEL.send(PacketDistributor.DIMENSION.with(() -> ((ServerLevel)level).m_46472_()), (Object)new PacketPriceMultiplier(map));
    }
}

